/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.rmi;

import filenet.vw.base.VWString;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class VWUnicastRemoteObject
extends UnicastRemoteObject {
    protected FileOutputStream fileStream;
    protected boolean logging = false;
    protected boolean tracing = false;

    public VWUnicastRemoteObject() throws RemoteException {
    }

    public VWUnicastRemoteObject(int port) throws RemoteException {
        super(port);
    }

    public Vector getProperties() throws RemoteException {
        VWString msg;
        Vector<String> properties = new Vector<String>();
        Properties props = System.getProperties();
        Enumeration<?> enum1 = props.propertyNames();
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            msg = new VWString("vw.rmi.ListFmt", "{0}: {1}", key, System.getProperty(key));
            properties.addElement(msg.toString());
        }
        Runtime runtime = Runtime.getRuntime();
        msg = new VWString("vw.rmi.MemoryTotal", "memory.total: {0}", Long.toString(runtime.totalMemory()));
        properties.addElement(msg.toString());
        msg = new VWString("vw.rmi.MemoryAvail", "memory.avail: {0}", Long.toString(runtime.freeMemory()));
        properties.addElement(msg.toString());
        Boolean ls = new Boolean(this.logging);
        msg = new VWString("vw.rmi.LoggingState", "logging.state: {0}", ls.toString());
        properties.addElement(msg.toString());
        Boolean ts = new Boolean(this.tracing);
        msg = new VWString("vw.rmi.TracingState", "tracing.state: {0}", ts.toString());
        properties.addElement(msg.toString());
        Thread.currentThread();
        msg = new VWString("vw.rmi.ThreadCount", "thread.count: {0}", Long.toString(Thread.activeCount()));
        properties.addElement(msg.toString());
        return properties;
    }

    public boolean getLoggingState() throws RemoteException {
        return this.logging;
    }

    public void setLoggingState(boolean state) throws RemoteException {
        try {
            if (state) {
                if (this.fileStream == null) {
                    this.fileStream = new FileOutputStream("vwrmi.log");
                }
                VWUnicastRemoteObject.setLog(this.fileStream);
            } else if (this.logging) {
                VWUnicastRemoteObject.setLog(null);
            }
            this.logging = state;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getTracingState() throws RemoteException {
        return this.tracing;
    }

    public void setTracingState(boolean state) throws RemoteException {
        this.tracing = state;
        Runtime.getRuntime().traceMethodCalls(this.tracing);
    }

    public String getVersion(String className) throws Exception {
        if (className != null) {
            try {
                int nFields;
                Class<?> cls = Class.forName(className);
                Object obj = cls.newInstance();
                Field[] fields = cls.getFields();
                StringBuffer buf = new StringBuffer(512);
                buf.append(className).append("\n");
                int n = nFields = fields == null ? 0 : fields.length;
                while (--nFields > 0) {
                    buf.append(fields[nFields].getName()).append("=").append(fields[nFields].get(obj)).append("\n");
                }
                return buf.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public long getRuntimeTotalMemory() throws Exception {
        long totalMemory = Runtime.getRuntime().totalMemory();
        return totalMemory;
    }

    public long getRuntimeFreeMemory() throws Exception {
        long freeMemory = Runtime.getRuntime().freeMemory();
        return freeMemory;
    }
}

